#define boneIndex gl_MultiTexCoord2
#define weight gl_MultiTexCoord3

uniform vec4 boneMatrix[10];

varying vec4 oColor;
varying vec2 oTexCoord;

void main()
{
	vec4 netPos=vec4(0,0,0,1);

	int i=int(boneIndex[0]);
	mat4 boneMat=mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],vec4(0,0,0,0));	
	netPos=(boneMat*vec4(gl_Vertex,1))*weight[0];

	gl_Position = gl_ModelViewProjectionMatrix * netPos;
	oColor=gl_Color;
	oTexCoord=gl_MultiTexCoord0.xy;
}

/*
vec4 calcLight(vec4 lightPos, vec3 pos, vec3 eyePos, vec3 norm)
{
	vec4 ambient=gl_LightSource[0].ambient;
	float dI=max(0.0,dot(lightPos.xyz,norm));
	vec4 colour;
	colour=(dI*gl_LightSource[0].diffuse)+ambient;
	colour.a=0.0;
	return colour;
}

void main()
{
	vec3 netPos=vec3(0,0,0);
	vec3 netNorm=vec3(0,0,0);
	vec4 zero4=vec4(0,0,0,1);
	
	//THIS LOOP NEEDS TO BE UNROLLED, BECAUSE ATi's GLSL COMPILER ISN'T SMART ENOUGH TO DO IT
	for (int a=0;a<4;a++)
	{
		int i=int(boneIndex[a]);
		mat4 boneMat = mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],zero4);	
		mat3 rotMat = mat3(boneMat[0].xyz, boneMat[1].xyz, boneMat[2].xyz);
		netPos+=(boneMat*vec4(gl_Vertex,1)).xyz*weight[a];
		netNorm+=(rotMat*gl_Normal)*weight[a];
	}
	//START UNROLL
	int i=int(boneIndex[0]);
	mat4 boneMat = mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],zero4);	
	mat3 rotMat = mat3(boneMat[0].xyz, boneMat[1].xyz, boneMat[2].xyz);
	netPos+=(boneMat*vec4(gl_Vertex,1)).xyz*weight[0];
	netNorm+=(rotMat*gl_Normal)*weight[0];

	i=int(boneIndex[1]);
	boneMat = mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],zero4);	
//	rotMat = mat3(boneMat[0].xyz, boneMat[1].xyz, boneMat[2].xyz);
//	netPos+=(boneMat*vec4(gl_Vertex,1)).xyz*weight[1];
//	netNorm+=(rotMat*gl_Normal)*weight[1];
	
	i=int(boneIndex[2]);
	boneMat = mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],zero4);	
	rotMat = mat3(boneMat[0].xyz, boneMat[1].xyz, boneMat[2].xyz);
	netPos+=(boneMat*vec4(gl_Vertex,1)).xyz*weight[2];
	netNorm+=(rotMat*gl_Normal)*weight[2];

	i=int(boneIndex[3]);
	boneMat = mat4(boneMatrix[i+0],boneMatrix[i+1],boneMatrix[i+2],zero4);	
	rotMat = mat3(boneMat[0].xyz, boneMat[1].xyz, boneMat[2].xyz);
	netPos+=(boneMat*vec4(gl_Vertex,1)).xyz*weight[3];
	netNorm+=(rotMat*gl_Normal)*weight[3];
	//END UNROLL

//	netPos=gl_Vertex.xyz;
//	netNorm=gl_Normal;
	
	netNorm=normalize(netNorm);
	gl_Position = gl_ModelViewProjectionMatrix * vec4(netPos,1);
	oColor=gl_Color*calcLight(gl_LightSource[0].position, netPos, vec3(0.0,0.0,0.0), netNorm);
	oTexCoord=gl_MultiTexCoord0.xy;
}
*/